	function PLOT_PHASE_DELAY_Z(wT, Tauf, axis_Tauf_min, axis_Tauf_max, m)
 
	% 	Plots the phase delay for a digital filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2005-05-08
	% 	Modified by: 	LW 2010-11-25
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		
	% 	Known bugs:	 
	% 	Report bugs to:	lars.wanhammar@liu.se
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================	
	
	axis([0 max(wT) axis_Tauf_min axis_Tauf_max]);
 	plot(wT, Tauf,'linewidth', lw) 
	
	if m == 6	% trick to avoid messy printing of axis
		ylabel('{\it\tau_f}({\ite^j^\omega^T}) [T]','FontName', fn,'FontSize',fs);
		xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
		set(gca,'FontName', fn,'FontSize', fs);
		ax = [0 0.1*pi 0.2*pi  0.3*pi  0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];	
		lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};	
		xtick(ax,lab);
		%	box on;
		grid on
	end
